/*
 * 		 	Vigenre  v1.0 Crypter  03-07-2003
 *
 *  2003 All Rights Reserved to Didier STRAUS
 *
 *  mailto: Software-DS@wanadoo.fr
 *  http://www.Software-DS.com
 */

#include <stdio.h>
#include <string.h>
#define dim 74

int main(void) {
	int i,j,k=0;
	char * pswd;
	char chaine[dim]="ABCDEFGHIJKLMNOPQRSTUVWXYZ abcdefghijklmnopqrstuvwxyz0123456789.,;:()+-*/=";
	char tab[dim][dim];
	FILE * lecture;
	
	printf("                  Vigenre  v1.0 Crypter\n\n");
	printf("http://www.Software-DS.com  Software-DS@wanadoo.fr\n\n");
	
	printf("Le programme permet de crypter un fichier texte compos des caractres : ");
	for(i=0;i<dim;i++)
		printf("%c",chaine[i]);
	printf("\n");
	
	/* Cration du carr de Vigenre */
	for(i=0;i<dim;i++) {
		for(j=0;j<dim;j++) {
			if (j+k<dim)
				tab[i][j]=chaine[j+k];
			else
				tab[i][j]=chaine[j+k-dim];
		}
		k++;
	}
	printf("\n");
	
	/* Pour afficher le carr de Vignenre */
	/*
	for(j=0;j<dim;j++){
		for(i=0;i<dim;i++)
			printf("%c",tab[j][i]);
		printf("\n");
	}
	*/
	
	lecture=fopen("texte","r");
	if (!lecture) { /* Ouverture du fichier russi ? */
		printf("\nProbleme: Le fichier 'texte' n'a pas t trouv !\n\a");
		printf("\nVerifier bien le nom de votre fichier: texte\n");
	}
	else {
		FILE * save;
		int taille,longueur;
		
		printf("Saisir votre mot de passe :");
		scanf("%s",pswd);
		longueur=strlen(pswd);
		
		/* Calcul de la taille du fichier  crypter */
		fseek(lecture,0,SEEK_END);
		taille=ftell(lecture);
		fseek(lecture,0,SEEK_SET);
		
		/* Cration du fichier crypter */
		save=fopen("texte crypter","w");
		if (!lecture) { /* Cration du fichier russi ? */
			printf("\nProbleme: impossible de crer le fichier 'texte crypter'\n\a");
		}
		else {
			int t[200]; /* taille limite du mot de passe */
			int pos=0;
			
			for(i=0;i<longueur;i++){
				j=-1;
				do{
					j++;
				} while ((j<dim) && (tab[j][0]!=pswd[i]));
				t[i]=j;
			}
/* t contient les N de ligne du carr de Vigenre qui vont etre utilis pour le cryptage */

			/* On parcours le fichier  crypter */
			for(i=0;i<taille;i++) {
				char c;
				
				j=-1;
				fread(&c,sizeof(char),1,lecture);
				do{
					j++;
				} while((chaine[j]!=c) && (j<dim));
				
				if (j<dim) {
					c=tab[t[pos]][j];
					pos++;
					if (pos>=longueur)
						pos=0;
				}
				fprintf(save,"%c",c);
			}
		fclose(save);			
		}
		fclose(lecture);
	}
	
	printf("\n\nFin.\n\n");
	printf ("\n\n2003 All Rights Reserved to Didier STRAUS\n\n");
	return 0;
}
